//Experiment-12
//windows 8.1 - 64-Bit
//Scilab - 6.0.0

//Aim :A SCILAB program for Design of Electromagnet
//Data:Design a flat faced armature type of circular electromagnet

clc
clear

//Following data is to be taken form the user

F=input('Enter Amount of force in kg') // force to be exerted by electromagnet in kg(in the range of 100 - 250 kg)
s=input('Enter value of stroke in mm') // stroke in mm (in the range of 0.5 - 1.5 mm)
v=input('Enter supply volage') // in the range of 5 - 15 volts
ta=input('Enter ambient temperature in degree celcius') // general value is 20 oC
t=input('Enter permissible temperature rise above ambient temperature') // 50 - 80 oC

//Actual Calculations begin

Bm = 1.1 // maximum flux density in Wb/m^2
uo = 4*%pi*1e-7
ro_0=0.01734 // resistib=vity at 0 degree
alp_0=0.00393 // temperature coefficient of resistance
h_by_d=3 // heigth to depth ratio of coil
C=0.085 // constant
Sf=0.5 // assumed space factor

A  = F*uo/(0.102*Bm^2) // are of central limb
r1 = sqrt(A/%pi) // radius of central limb
//disp(r1)
AT=(1600000*Bm*s*1e-3)/0.85 // total mmf required
ro_70=ro_0*(1+(alp_0*t))
hc=((3*ro_70*C*AT^2)/(2*Sf*t)*1e-6)^(1/3) // heigth of coil
//disp(hc)
dc=hc/3 //depth of coil
//disp(dc)
r2=dc+r1
//disp(r2)
t1=r1/2
//disp(t1)
t2=(r1^2)/(2*r2)
//disp(t2)
r3=sqrt(r1^2+r2^2)
//disp(r3)
a=(AT*ro_70*%pi*(r1+r2))*1e-3/v // cross sectional area of conductor
//disp(a)
d=sqrt(4*a*1000/%pi) // diameter of conductor
//disp(d)
dc1=dc*1000-2 // depth of coil considering clearance
//disp(dc1)
nd=ceil(dc1/d) // no. of layers in depth
//disp(nd)
hc1=hc*1000-3 // height of coil considering clearance
nh=ceil(hc1/d) // no o flayers in height
//disp(nh)
T=nd*nh // no. of turns in coil
//disp(T)
ab=(%pi/4*d^2) // diameter of bare conductor
R=T*ro_70*(%pi*(r1+r2))/ab // resistance of coil
//disp(R)
I=v/R; // current in coil
//disp(I)
mmf=I*T // actual mmf developed by coil
//disp(mmf)
sf=T*ab/(hc*dc) // actual space factor
//disp(sf)
theta = (ro_70*C*mmf^2*1e-6)*1e6/(2*sf*dc*hc^2)
//disp(theta  )

mprintf('heigth of coil is %f mm',hc*1000)
mprintf('\n')
mprintf('depth of coil is %f mm',dc*1000)
mprintf('\n')
mprintf('total no. of turns in the coil are %d',T)
mprintf('\n')
mprintf('Current flowing through the coil is  %f Amp',I)
mprintf('\n')
mprintf('MMF developed by the coil is %d AT',mmf)
mprintf('\n')
mprintf('Temperature rise of the coil is %f oC',theta)
mprintf('\n')
